<?php
/**
 * Smartideo - WordPress 视频嵌入增强插件
 * @package Smartideo
 * @author Fens Liu
 * @license GPL-2.0+
 * @link https://7yper.com/3639
 * @version 2.8.1
 */
/*
Plugin Name: Smartideo
Plugin URI: https://7yper.com/3639
Description: Smartideo 是为 WordPress 添加对在线视频和音乐支持的一款插件（支持手机、平板等设备HTML5播放）。目前支持 YouTube、哔哩哔哩、抖音、优酷、腾讯视频、网易云音乐、QQ音乐 等网站。
Version: 2.8.1
Stable tag: 2.8.1
Author: Fens Liu
Author URI: https://7yper.com/3639
*/

define('SMARTIDEO_VERSION', '2.8.1');
define('SMARTIDEO_URL', plugins_url('', __FILE__));
define('SMARTIDEO_PATH', dirname(__FILE__));

// 加载古腾堡编辑器支持
if (function_exists('register_block_type')) {
	require_once SMARTIDEO_PATH . '/smartideo-gutenberg.php';
}

$smartideo = new smartideo();

class smartideo {
	private $edit = false;
	private $width = '100%';
	private $height = '500px';
	private $youku_client_id = 'd0b1b77a17cded3b';
	private $bilibili_pc_player = 0;
	private $option = array();
	public function __construct(){
		if(is_admin()){
			add_action('admin_menu', array($this, 'admin_menu'));
			$this->edit = true;
		}

        $option = get_option('smartideo_option');
        if(empty($option)){
            $option = array();
        }
        $this->option = $option;
        extract((array)$option);
        if(!empty($youku_client_id) && strlen($youku_client_id) == 16){
            $this->youku_client_id = $youku_client_id;
        }
        $this->bilibili_pc_player = isset($bilibili_pc_player) ? $bilibili_pc_player : 0;

        add_action('wp_enqueue_scripts', array($this, 'smartideo_scripts'));

		wp_embed_unregister_handler('youku');
		wp_embed_unregister_handler('youtube');

		// 平台支持
		wp_embed_register_handler('smartideo_youtube',
			'#https?://www\.youtube\.com/watch\?v=([a-zA-Z0-9_=\-]+)#i',
			array($this, 'smartideo_embed_handler_youtube'));
        
		wp_embed_register_handler('smartideo_bilibili',
			'#https?://(?:www\.|mobile\.)?bilibili\.(?:com|tv)/(?:video/(BV|av)([a-zA-Z0-9_=\-]+)|BV([a-zA-Z0-9_=\-]+)|av(\d+))#i',
			array($this, 'smartideo_embed_handler_bilibili'));
        
		wp_embed_register_handler('smartideo_douyin',
			'#https?://(?:www\.)?douyin\.com/(?:video/|jingxuan\?modal_id=|discover\?modal_id=|share/?(?:video/)?|user\d+\?modal_id=)(\d+)#i',
			array($this, 'smartideo_embed_handler_douyin'));
        
		wp_embed_register_handler('smartideo_youku',
			'#https?://(?:v|vo|u)\.youku\.com/(?:v_show/id_|video/id_)?([a-z0-9_=\-]+)(?:\.html|\.htm)?#i',
			array($this, 'smartideo_embed_handler_youku'));

		wp_embed_register_handler('smartideo_qq',
			'#https?://v\.qq\.com/(?:[a-z0-9_\./]+\?vid=([a-z0-9_=\-]+)|(?:[a-z0-9/]+)/([a-z0-9_=\-]+))#i',
			array($this, 'smartideo_embed_handler_qq'));
        
		// 音乐平台支持
		wp_embed_register_handler('smartideo_music163',
			'#https?://(?:music\.163\.com|y\.163\.com)(?:/\#|/|)?/(?:song|song\?id=|program\?id=|mv\?id=)(\d+)#i',
			array($this, 'smartideo_embed_handler_music163'));

		wp_embed_register_handler('smartideo_musicqq',
			'#https?://(?:y\.qq\.com|c\.y\.qq\.com|i\.y\.qq\.com)/(?:n/ryqq/songDetail/|n/yqq/song/|playsong\.html\?songid=|new\.music\.qq\.com/v8/fcg-bin/play\.fcg\?songmid=)([a-zA-Z0-9_=\-]+)#i',
			array($this, 'smartideo_embed_handler_musicqq'));

	}

	// 平台处理函数
	public function smartideo_embed_handler_youtube($matches, $attr, $url, $rawattr) {
		$embed = $this->get_iframe("//www.youtube.com/embed/{$matches[1]}", $url);
		return apply_filters('embed_youtube', $embed, $matches, $attr, $url, $rawattr);
	}

	public function smartideo_embed_handler_bilibili($matches, $attr, $url, $rawattr) {
		// 找到非空的视频ID捕获组
		$video_id = '';
		for ($i = 2; $i <= 4; $i++) {
			if (!empty($matches[$i])) {
				$video_id = $matches[$i];
				break;
			}
		}
		$matches['video_id'] = $video_id;
		$page = 1;
		$cid = '';
        if(wp_is_mobile() || $this->bilibili_pc_player == 1){
            $aid = 0;
            $bvid = '';
            if(is_numeric($matches['video_id'])){
                $aid = $matches['video_id'];
            }else{
                $bvid = $matches['video_id'];
            }
            $embed = $this->get_iframe("//player.bilibili.com/player.html?aid={$aid}&bvid={$bvid}&cid={$cid}&page={$page}&autoplay=0", $url);
        }else{
            $embed = $this->get_link($url);
        }
        return apply_filters( 'embed_bilibili', $embed, $matches, $attr, $url, $rawattr );
    }

	public function smartideo_embed_handler_douyin($matches, $attr, $url, $rawattr) {
		$video_id = isset($matches[1]) ? $matches[1] : '';
		$embed = $this->get_iframe("//open.douyin.com/player/video?vid={$video_id}&autoplay=0", $url, '324px', '672px');
		// 为抖音视频添加douyin类名以便样式控制
		$embed = str_replace('smartideo-responsive', 'smartideo-responsive douyin', $embed);
		return apply_filters('embed_douyin', $embed, $matches, $attr, $url, $rawattr);
	}

	public function smartideo_embed_handler_youku($matches, $attr, $url, $rawattr) {
		$embed = $this->get_iframe("//player.youku.com/embed/{$matches[1]}?client_id={$this->youku_client_id}", $url);
		return apply_filters('embed_youku', $embed, $matches, $attr, $url, $rawattr);
	}

	public function smartideo_embed_handler_qq($matches, $attr, $url, $rawattr) {
		$video_id = isset($matches[1]) && $matches[1] != '' ? $matches[1] : (isset($matches[2]) ? $matches[2] : '');
		$embed = $this->get_iframe("//v.qq.com/iframe/player.html?vid={$video_id}&auto=0", $url);
		return apply_filters('embed_qq', $embed, $matches, $attr, $url, $rawattr);
	}

	// 音乐平台处理函数
	public function smartideo_embed_handler_music163($matches, $attr, $url, $rawattr) {
		$embed = $this->get_iframe("//music.163.com/outchain/player?type=2&id={$matches[1]}&auto=0&height=60", $url, '100%', '80px');
		return apply_filters('embed_music163', $embed, $matches, $attr, $url, $rawattr);
	}
	
	public function smartideo_embed_handler_musicqq($matches, $attr, $url, $rawattr) {
		$embed = $this->get_iframe("//i.y.qq.com/n2/m/outchain/player/index.html?songid={$matches[1]}&songtype=0", $url, '100%', '60px');
		return apply_filters('embed_musicqq', $embed, $matches, $attr, $url, $rawattr);
	}

	private function get_embed($url = '', $source = '', $width = '', $height = '') {
		$html = '';
		$html .= '<div class="smartideo">
			<div class="player"' . $this->get_size_style($width, $height) . '>
				<embed src="' . $url . '" allowFullScreen="true" quality="high" width="100%" height="100%" allowScriptAccess="always" type="application/x-shockwave-flash" wmode="transparent"></embed>
			</div>';
        if($this->option['tips_status'] == 1 && !$this->edit){
            if(empty($source)){
                $source = 'javascript:void(0);';
            }
            $html .= '<div class="tips">
                    <a href="' . $source . '" target="_blank" smartideo-title="' . $this->option['tips_content'] . '" smartideo-title-mobile="' . $this->option['tips_content_mobile'] . '" title="' . $this->option['tips_content'] . '" class="smartideo-tips" rel="nofollow"></a>
                </div>';
        }
        $html .= '</div>';
        return $html;
    }

	private function get_iframe($url = '', $source = '', $width = '', $height = '') {
		$html = '';
		// 响应式模式
		$responsive_class = '';
		if(!$this->edit && isset($this->option['response']) && $this->option['response'] == 1){
			$responsive_class = ' smartideo-responsive';
		}
        
		$html .= '<div class="smartideo' . $responsive_class . '">
			<div class="player"' . $this->get_size_style($width, $height) . '>
				<iframe src="' . $url . '" width="100%" height="100%" frameborder="0" allowfullscreen="true" allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture"></iframe>
			</div>';
        if(isset($this->option['tips_status']) && $this->option['tips_status'] == 1 && !$this->edit){
            if(empty($source)){
                $source = 'javascript:void(0);';
            }
            $html .= '<div class="tips">
                    <a href="' . $source . '" target="_blank" smartideo-title="' . $this->option['tips_content'] . '" smartideo-title-mobile="' . $this->option['tips_content_mobile'] . '" title="' . $this->option['tips_content'] . '" class="smartideo-tips" rel="nofollow"></a>
                </div>';
        }
        $html .= '</div>';
        return $html;
    }
    
	private function get_link($url) {
		$html = '';
		$html .= '<div class="smartideo">
			<div class="player"' . $this->get_size_style(0, 0) . '>
				<a href="' . $url . '" target="_blank" class="smartideo-play-link"><div class="smartideo-play-button"></div></a>
				<p style="color: #999;margin-top: 50px;">暂时无法播放，可回源网站播放</p>
			</div>
		</div>';
		return $html;
	}

	public function smartideo_scripts() {
		wp_enqueue_style('smartideo_css', SMARTIDEO_URL . '/static/smartideo.css', array(), SMARTIDEO_VERSION, 'screen');
		wp_enqueue_script('smartideo_js', SMARTIDEO_URL . '/static/smartideo.js', array(), SMARTIDEO_VERSION, true);
	}

	public function admin_menu() {
		add_plugins_page('Smartideo 设置', 'Smartideo 设置', 'manage_options', 'smartideo_settings', array($this, 'admin_settings'));
	}

	public function admin_settings() {
		require_once 'smartideo-admin.php';
		new smartideo_admin();
	}

	private function is_https() {
		return strtolower($_SERVER['HTTPS']) == 'on';
	}
	
	private function get_size_style($width, $height){        
		if(empty($width) || empty($height)){
			$width = $height = 0;
			if($this->edit){
				$width = $this->width;
				$height = $this->height;
			}else if(isset($this->option['response']) && $this->option['response'] == 0){
				if(wp_is_mobile()){
					$width = $this->option['width_mobile'];
					$height = $this->option['height_mobile'];
				}else{
					$width = $this->option['width'];
					$height = $this->option['height'];
				}
			}
		}
		$style = '';
		if(!empty($width)){
			$style .= "width: {$width};";
		}
		// 响应式模式下不设置height
		if(!empty($height) && (!isset($this->option['response']) || $this->option['response'] == 0)){
			$style .= "height: {$height};";
		}
		if(!empty($style)){
			$style = ' style="' . $style . '"';
		}
		return $style;
	}
}
